package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.ItemData;
import jamezo97.clonecraft.item.ItemEntitySequencePaper;

import java.util.ArrayList;
import java.util.Random;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class TileEntityGeneExtractor extends TileEntity implements IInventory{

	public int extractTime;

	private ItemStack[] items = new ItemStack[18];

	public int burnTime;

	public int currentItemBurnTime;


	public int getSizeInventory()
	{
		return this.items.length;
	}

	public ItemStack getStackInSlot(int par1)
	{
		return this.items[par1];
	}

	/**
	 * Removes from an inventory slot (first arg) up to a specified number (second arg) of items and returns them in a
	 * new stack.
	 */
	public ItemStack decrStackSize(int par1, int par2)
	{
		if (this.items[par1] != null)
		{
			ItemStack itemstack;

			if (this.items[par1].stackSize <= par2)
			{
				itemstack = this.items[par1];
				this.items[par1] = null;
				return itemstack;
			}
			else
			{
				itemstack = this.items[par1].splitStack(par2);

				if (this.items[par1].stackSize == 0)
				{
					this.items[par1] = null;
				}

				return itemstack;
			}
		}
		else
		{
			return null;
		}
	}

	public ItemStack getStackInSlotOnClosing(int par1)
	{
		if (this.items[par1] != null)
		{
			ItemStack itemstack = this.items[par1];
			this.items[par1] = null;
			return itemstack;
		}
		else
		{
			return null;
		}
	}

	/**
	 * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
	 */
	public void setInventorySlotContents(int par1, ItemStack par2ItemStack)
	{
		this.items[par1] = par2ItemStack;

		if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit())
		{
			par2ItemStack.stackSize = this.getInventoryStackLimit();
		}
	}

	/**
	 * Reads a tile entity from NBT.
	 */
	public void readFromNBT(NBTTagCompound nbt)
	{
		super.readFromNBT(nbt);
		NBTTagList nbttaglist = nbt.getTagList("Items");
		this.items = new ItemStack[this.getSizeInventory()];

		for (int i = 0; i < nbttaglist.tagCount(); ++i)
		{
			NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
			byte b0 = nbttagcompound1.getByte("Slot");

			if (b0 >= 0 && b0 < this.items.length)
			{
				this.items[b0] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
			}
		}
		extractTime =  nbt.getInteger("extractTime");
		burnTime = nbt.getInteger("burnTime");
		currentItemBurnTime = nbt.getInteger("currentItemBurnTime");
	}

	/**
	 * Writes a tile entity to NBT.
	 */
	public void writeToNBT(NBTTagCompound nbt)
	{
		super.writeToNBT(nbt);
		NBTTagList nbttaglist = new NBTTagList();

		for (int i = 0; i < this.items.length; ++i)
		{
			if (this.items[i] != null)
			{
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.setByte("Slot", (byte)i);
				this.items[i].writeToNBT(nbttagcompound1);
				nbttaglist.appendTag(nbttagcompound1);
			}
		}

		nbt.setTag("Items", nbttaglist);

		nbt.setInteger("extractTime", extractTime);
		nbt.setInteger("burnTime", burnTime);
		nbt.setInteger("currentItemBurnTime", currentItemBurnTime);
	}


	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		return false;
	}

	/**
	 * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
	 * this more of a set than a get?*
	 */
	public int getInventoryStackLimit()
	{
		return 64;
	}


	@Override
	public void openChest() {
	}

	@Override
	public void closeChest() {
	}
	@Override
	public String getInvName() {
		return "Gene Extractor";
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		return true;
	}



	float incubateTrans = 0.0f;

	public float GetIncubateTransition(){
		return incubateTrans;
	}


	int currentIndex = 0;

	Random rand = new Random();

	//Time to take = 4 minutes. 4800 ticks

	int timeToExtract = CloneCraft.isDebugMode()?120:4800;

	/**
	 * Returns an integer between 0 and the passed value representing how close the current item is to being completely
	 * cooked
	 */
	public int getExtractProgressScaled(int par1)
	{
		return this.extractTime * par1 / timeToExtract;
	}
	
	public float getPercentComplete(){
		return ((float)extractTime) / ((float)timeToExtract);
	}

	@SideOnly(Side.CLIENT)

	/**
	 * Returns an integer between 0 and the passed value representing how much burn time is left on the current fuel
	 * item, where 0 means that the item is exhausted and the passed value means that the item is fresh
	 */
	public int getBurnTimeRemainingScaled(int par1)
	{
		if (this.currentItemBurnTime == 0)
		{
			this.currentItemBurnTime = 200;
		}

		return this.burnTime * par1 / this.currentItemBurnTime;
	}

	/**
	 * Returns true if the furnace is currently burning
	 */
	public boolean isBurning()
	{
		return this.burnTime > 0;
	}

	long ticks = 0;

	/**
	 * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
	 * ticks and creates a new spawn inside its implementation.
	 */
	public void updateEntity()
	{
		boolean flag = this.burnTime > 0;
		boolean flag1 = false;

		if (this.burnTime > 0)
		{
			--this.burnTime;
		}

		if (!this.worldObj.isRemote)
		{
			if (this.burnTime == 0 && this.canExtract())
			{
				this.currentItemBurnTime = this.burnTime = TileEntityFurnace.getItemBurnTime(this.items[3]);

				if (this.burnTime > 0)
				{
					flag1 = true;

					if (this.items[3] != null)
					{
						--this.items[3].stackSize;

						if (this.items[3].stackSize == 0)
						{
							this.items[3] = this.items[3].getItem().getContainerItemStack(items[3]);
						}
					}
				}
			}

			if (this.isBurning() && this.canExtract())
			{
				++this.extractTime;

				if (this.extractTime >= timeToExtract)
				{
					this.extractTime = 0;
					this.onExtracted();
					flag1 = true;
				}else{
					if(this.extractTime % 25 == 0){
						worldObj.playSoundEffect(xCoord, yCoord, zCoord, "clonecraft.humfade", 1.0f, 1.2f);
					}
				}
			}
			else
			{
				this.extractTime = 0;
			}

			if (flag != this.burnTime > 0)
			{
				flag1 = true;
			}
		}
		
		if(worldObj.isRemote){
			if(isBurning()){
				if(incubateTrans < 1.0f){
					incubateTrans += 0.0125;
				}
				if(incubateTrans > 1.0f){
					incubateTrans = 1.0f;
				}
				worldObj.spawnParticle("smoke", xCoord+0.5f+((rand.nextFloat()-0.5f)/5), yCoord+1.05f, zCoord+0.5f+((rand.nextFloat()-0.5f)/5), 0.0D, 0.1D + rand.nextFloat()/5, 0.0D);
				if(ticks++ % 2 == 0){
					worldObj.spawnParticle("flame", xCoord+0.5f+((rand.nextFloat()-0.5f)/5), yCoord+1.05f, zCoord+0.5f+((rand.nextFloat()-0.5f)/5), 0.0D, 0.02D, 0.0D);
				}
			}else{
				if(incubateTrans > 0.0f){
					incubateTrans -= 0.0125;
				}
				if(incubateTrans < 0.0f){
					incubateTrans = 0.0f;
				}
			}
		}
		
		if (flag1)
		{
			this.onInventoryChanged();
		}

			
	}

	public void onExtracted(){
		if(items[0] != null){
			ItemStack clean = items[0].copy();
			items[0].stackSize--;
			if(items[0].stackSize == 0){
				items[0] = null;
			}
			clean.stackSize = 1;
			clean.setItemDamage(0);
			clean.setTagCompound(null);
			mergeOutputStack(clean, 14, 18);
		}
		if(items[1] != null){
			ItemStack empty = items[1].copy();
			items[1].stackSize--;
			if(items[1].stackSize == 0){
				items[1] = null;
			}
			empty.stackSize = 1;
			empty.setItemDamage(0);
			new ItemData(empty).drain().save();
			mergeOutputStack(empty, 14, 18);
		}
		if(items[4] != null && rand.nextFloat() >= 0.1f){
			int amount = 1 + rand.nextInt(10)/7;
			for(int a = 0; a < amount; a++){
				if(items[4] == null)break;
				ItemStack tube = items[4].copy();
				tube.stackSize = 1;
				items[4].stackSize--;
				if(items[4].stackSize < 1){
					items[4] = null;
				}
				tube.setItemDamage(4);
				mergeOutputStack(tube, 14, 18);
			}
			
		}
		if(items[5] != null && items[2] != null){
			ArrayList<Integer> list = ItemEntitySequencePaper.entityIdToGene.get(items[2].getItemDamage());
			for(int a = 0; a < list.size(); a++){
				if(items[5] == null || items[5].stackSize < 1)break;
				ItemStack tube = items[5].copy();
				tube.stackSize = 1;
				tube.setItemDamage(3);
				new ItemData(tube).setGene(list.get(a)).save();
				this.mergeOutputStack(tube, 6, 14);
				items[5].stackSize--;
				if(items[5].stackSize < 1){
					items[5] = null;
				}
			}
		}
	}
	
	public void mergeOutputStack(ItemStack out, int min, int max){
		for(int a = min; a < max; a++){
			ItemStack inSlot = items[a];
			if(ItemStack.areItemStackTagsEqual(inSlot, out) && out.itemID == inSlot.itemID && out.getItemDamage() == inSlot.getItemDamage()){
				int reduce = out.stackSize;
				if(reduce > (inSlot.getMaxStackSize() - inSlot.stackSize)){
					reduce = inSlot.getMaxStackSize() - inSlot.stackSize;
				}
				out.stackSize-=reduce;
				inSlot.stackSize+=reduce;
			}
			if(out.stackSize == 0){
				return;
			}
		}
		if(out != null && out.stackSize > 0){
			for(int a = min; a < max; a++){
				ItemStack inSlot = items[a];
				if(inSlot == null){
					items[a] = out.copy();
					out.stackSize = 0;
				}
				if(out.stackSize == 0){
					return;
				}
			}
		}
		if(out != null && out.stackSize > 0){
			EntityItem entity = new EntityItem(worldObj, this.xCoord + 0.5, this.yCoord + 1.0, this.zCoord + 0.5, out);
			worldObj.spawnEntityInWorld(entity);
		}
	}

	/**
	 * Returns true if the furnace can smelt an item, i.e. has a source item, destination stack isn't full, etc.
	 */
	private boolean canExtract(){
		if(items[0] != null && (items[0].itemID == CloneCraft.needle.itemID || items[0].itemID == CloneCraft.testTube.itemID) && items[0].getItemDamage() == 0 && (new ItemData(items[0])).isContaminated()){
			if(items[1] != null && items[1].itemID == CloneCraft.needle.itemID && items[1].getItemDamage() == 2){
				if(items[2] != null && items[2].itemID == CloneCraft.dnaData.itemID){
					if(items[5] != null && new ItemData(items[1]).currentEntity == items[2].getItemDamage()){
						ArrayList<Integer> list = ItemEntitySequencePaper.entityIdToGene.get(items[2].getItemDamage());
						int size = list.size();
						if(items[5].stackSize >= size){
							return true;
						}
						/*if(list != null){
							boolean allThere = true;
							for(int a = 13; a > 13 - list.size() && a > 4; a--){
								ItemStack testTube = items[a];
								if(!(testTube != null && testTube.itemID == CloneCraft.testTube.itemID && testTube.getItemDamage() == 0 && !new ItemData(testTube).isContaminated())){
									allThere = false;
									break;
								}
							}
							return allThere;
						}else{
							return false;
						}*/
					}
				}
			}
		}
		return false;
	}

	public boolean isEmpty() {
		for(int a = 0; a < items.length; a++){
			if(items[a] != null){
				return false;
			}
		}
		return true;
	}
	
}


/*
 * Slot1: Contaminated Item
 * Slot2: Entity DNA
 * Slot3: Entity Sequence Data
 * Slot4: Clean Test-Tube
 * Slot5: Coal
 * 
 * Phrases:
 * 0.05 Collecting Bateria
 * 0.10 Harvesting Plasmids
 * 0.15 Splitting DNA Sample
 * 0.30 Splicing DNA Samples Into Bacterial Plasmids
 * 0.70 Incubating Bacteria
 * 0.80 Decomposing Bacterial Walls
 * 0.85 Harvesting new Plasmids
 * 0.90 Collecting Duplicated DNA
 * 0.95 Injecting Duplicated Genes Into Test Tubes
 * 1.00 Done
 * */
//Flint, Bucket, Needle, Redstone, Diamond, Furnace, IronBlock
